<?php
/**
 *  Template Name: Career page
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package abe
 */

get_header();
?>
<div class="inner-banner-container">
            <div class="inner-banner">
                <h1>Career</h1>
                <p class="m-auto"><?php echo get_the_content(get_the_ID());?></p>
            </div>
</div>
<div class="main-container">
            <div class="careers">
                <div class="content m-auto">
                <ul class="career-listings">
                <?php

$query = new WP_Query(array('post_type' => 'careers', 'posts_per_page' => -1,'post_status' => 'publish', 'order' => 'DESC'));
while ($query->have_posts()): $query->the_post();
    ?>
    
                    <li>
                        <h2><?php the_title(); ?> <span>Posted On: <?php echo get_the_date(); ?></span></h2>
                        <span class="location">Exp: <?php echo get_post_meta(get_the_ID(), 'exp', true); ?></span>
                        <p><?php echo substr(get_the_content(), 0, 350); ?></p>
                        <div class="col-md-12">
                            <div class="row career-listing-footer">
                            <a href="<?php the_permalink(); ?>" class="readmore">Read More</a>
                        <a href="<?php the_permalink(); ?>" class="apply-now custom-btn "> Apply Now</a>
                            </div>
                    </li>
                    <?php endwhile; ?> <?php wp_reset_postdata();?> 
                </ul>
                </div>
               
            </div>
            <?php get_footer();